################################################
#0 - Introduction 
################################################

#Appel du package sampling
library(sampling)
help(package="sampling")

#Appel du package gustave
library(gustave)
help(package="gustave")

#Récupération de deux bases de données du package
data("MU284")
attach(MU284)

data("belgianmunicipalities")
attach(belgianmunicipalities)

#Etude descriptive du fichier belgianmunicipalities 
attributes(belgianmunicipalities)
#16 variables dans le fichier
str(belgianmunicipalities)

################################################
#1 - Rappels sur les méthodes d'échantillonnage
################################################

#################################################################
#Calcul de probabilités d'inclusion proportionnelles à la taille
#################################################################
n=50
pi_50=inclusionprobabilities(averageincome,n)
summary(pi_50)

n=400
pi_400=inclusionprobabilities(averageincome,n)
summary(pi_400)

#################################################################
#Tirage d'un échantillon selon un plan réjectif
#################################################################

ech=UPmaxentropy(pi_50)
#Estimation de HT du total de TaxableIncome 
y=TaxableIncome
est_ht=HTestimator(y[ech==1],pi_50[ech==1])
est_ht

#################################################################
#Calcul de probabilités d'inclusion d'ordre 2
#################################################################

#Tirage réjectif
pikl_rej_50=UPmaxentropypi2(pi_50)
#Méthode de Rao-Sampford
pikl_sam_50=UPsampfordpi2(pi_50)
#Tirage systématique
pikl_sys_50=UPsystematicpi2(pi_50)
#Comparaison des probabilités d'inclusion d'ordre 2 obtenues
max(abs(pikl_rej_50-pikl_sam_50))
max(abs(pikl_rej_50-pikl_sys_50))

#################################################################
#Estimateur de variance de HT
#################################################################

#Tirage d'un échantillon selon un plan réjectif
ech=UPmaxentropy(pi_50)
#Estimation de HT du total de TaxableIncome 
y=TaxableIncome
est_ht=HTestimator(y[ech==1],pi_50[ech==1])

#Estimation de variance de HT (PACKAGE SAMPLING)
vest_ht=varHT(y[ech==1],pikl_rej_50[ech==1,ech==1],1)
options("scipen"=-100,digits="4")
est_ht
vest_ht

#################################################################
#Estimateur de variance de YG
#################################################################

#Estimation de variance de YG (PACKAGE SAMPLING)
vest_yg=varHT(y[ech==1],pikl_rej_50[ech==1,ech==1],2)
vest_yg

#Estimation de variance de YG (PACKAGE GUSTAVE)
vest_yg_gus=varSYG(y[ech==1],pikl_rej_50[ech==1,ech==1])
vest_yg_gus

#################################################################
#Cas du SRS
#################################################################

#Méthode draw by draw
n=100
Npop=589
ech_srs=srswor(n,Npop)

#Méthode de sélection-rejet
n=100
Npop=589
ech_srs=srswor1(n,Npop)

#Estimation pour un SRS
pi <- rep(n/Npop,Npop)
y=TaxableIncome
est_ht=HTestimator(y[ech==1],pi_50[ech==1])
est_ht

#Estimation de variance pour un SRS (PACKAGE SAMPLING)
vest_srs=varest(y[ech==1],,pi[ech==1],)
vest_srs

#Estimation de variance pour un SRS (PACKAGE GUSTAVE)
vest_srs_gus=var_srs(y[ech==1],pi[ech==1])
vest_srs_gus

#######################################
#Une étude par simulations pour le SRS
#######################################

#Initialisation des paramètres
n=100
Npop=589
pi=rep(n/Npop,589)
sim=10000

#Pile des simulations pour Tot04 et TaxableIncome (Est,EstVar,Binf,Bsup)
pile_Tot04=array(0,c(sim,4))
pile_TaxableIncome=array(0,c(sim,4))

#Horvitz-Thompson estimator
ht=numeric(2)
#Variance estimator
ev=numeric(2)
#Confidence interval
ic=numeric(4)

#Etude par simulations : boucle de Monte-Carlo
for(i in 1:sim)
{
  cat("Simulation ",i,"\n")
  #Selection de l'échantillon
  ech=srswor1(n,Npop)
  #Estimation
  ht[1]=HTestimator(Tot04[ech==1],pi[ech==1])
  ht[2]=HTestimator(TaxableIncome[ech==1],pi[ech==1])
  #Estimation de variance
  ev[1]=varest(Tot04[ech==1],,pi[ech==1],)
  ev[2]=varest(TaxableIncome[ech==1],,pi[ech==1],)
  #Intervalle de confiance
  ic[1]=ht[1]-1.96*sqrt(ev[1])
  ic[2]=ht[1]+1.96*sqrt(ev[1])
  ic[3]=ht[2]-1.96*sqrt(ev[2])
  ic[4]=ht[2]+1.96*sqrt(ev[2])
  #Empilement
  pile_Tot04[i,]=cbind(ht[1],ev[1],ic[1],ic[2])
  pile_TaxableIncome[i,]=cbind(ht[2],ev[2],ic[3],ic[4])
  }

#Comparaison vrais totaux et estimateurs de HT
tot=c(sum(Tot04),sum(TaxableIncome))
Emc_ht=c(mean(pile_Tot04[,1]),mean(pile_TaxableIncome[,1]))
cat("Vrais totaux \n")
tot
cat("Espérance Monte Carlo \n")
Emc_ht

#Comparaison Variance et estimateur de variance
pikl_srs <- UPmaxentropypi2(pi)
var_srs=numeric(2)
var_srs[1] <- t(Tot04/pi)%*%(pikl_srs-pi%*%t(pi))%*%(Tot04/pi)
var_srs[2] <- t(TaxableIncome/pi)%*%(pikl_srs-pi%*%t(pi))%*%(TaxableIncome/pi)
Emc_ev=c(mean(pile_Tot04[,2]),mean(pile_TaxableIncome[,2]))
cat("Vraies variance \n")
var_srs
cat("Espérance Monte Carlo \n")
Emc_ev

#Taux de couverture intervalle de confiance
inside_Tot04=(pile_Tot04[,3]<tot[1]) * (tot[1]<pile_Tot04)
inside_TaxableIncome=(pile_TaxableIncome[,3]<tot[2]) * (tot[2]<pile_TaxableIncome[,4])
tc=c(mean(inside_Tot04),mean(inside_TaxableIncome))
cat("taux de couverture Monte Carlo \n")
options("scipen"=100,digits="3")
tc

#Coefficient de variation des var. d'intérêt
cv_Tot04 <- (sd(Tot04) / mean(Tot04)) * 100
cv_Tot04
cv_TaxInc <- (sd(TaxableIncome) / mean(TaxableIncome)) * 100 
cv_TaxInc

#########################################################
#2 - Méthodes d'échantillonnage à probabilités inégales
#########################################################

#########################################################
#Fonction de base sample
#########################################################

#Sélection d'un échantillon de 6 unités parmi les 10 premiers 
#entiers selon un SRS : GLOP
sample(1:10,6,replace = FALSE)

#Sélection d'un échantillon de 6 unités parmi les 10 premiers 
#entiers. Tirage avec remise à probabilités inégales : GLOP
prob <- c(1,1,1,1,1,2,2,2,2,2)
sample(1:10,6,replace = TRUE,prob)

#Sélection d'un échantillon de 6 unités parmi les 10 premiers 
#entiers. Tirage #sans remise à probabilités inégales : PAS GLOP
prob <- c(1,1,1,1,1,2,2,2,2,2)
sample(1:10,6,replace = FALSE,prob)

#########################################################
#2.1 - Tirage systématique
#########################################################

#Probabilités d'inclusion proportionnelles à la taille
n=50
Npop=589
pi_50=inclusionprobabilities(averageincome,n)
#Tirage systématique
ech_sys=UPsystematic(pi_50)

#Probabilités d'inclusion d'ordre 2
pikl_sys=UPsystematicpi2(pi_50)
options("scipen"=100,digits="3")
pikl_sys[1:6,1:6]

##############################################################
# Comparaison de la variance entre un SRS et un systematique 
# à probabilités égales pour une population ordonnée
##############################################################

#Corrélation entre Tot04 et TaxableIncome 
y=TaxableIncome
cor(Tot04,y)

#Tri de la population selon la variable Tot04
permutation <- order(Tot04)
Tot04_rank <- Tot04[permutation]
y_rank <- y[permutation]

#Paramètres de l'échantillonnage (probabilités égales)
n <- 50
Npop <- 589
pi0_50 <- rep(n/Npop,Npop)

#Probabilités d'inclusion d'ordre 2 pour un SRS
pikl_srs <- UPsampfordpi2(pi0_50)
#Variance exacte sous un SRS
var_srs <-t(y_rank/pi0_50)%*%(pikl_srs-pi0_50%*%t(pi0_50))%*%(y_rank/pi0_50)

#Probabilités d'inclusion d'ordre 2 pour le tirage systématique
pikl_sys <- UPsystematicpi2(pi0_50)
#Variance exacte sous un systématique
var_sys <- t(y_rank/pi0_50)%*%(pikl_sys-pi0_50%*%t(pi0_50))%*%(y_rank/pi0_50)

options("scipen"=-100,digits="3")
var_srs
var_sys
pikl_srs[1:10,1:10]
pikl_sys[1:10,1:10]

#########################################################
#2.2 - Méthode du pivot
#########################################################

#Probabilités d'inclusion proportionnelles à la taille
n=50
pi_50=inclusionprobabilities(averageincome,n)

#Tirage du pivot et estimation du total de TaxableIncome
ech_piv=UPpivotal(pi_50)
y=TaxableIncome
HTestimator(y[ech_piv==1],pi_50[ech_piv==1])

#Tirage du pivot randomisé et estimation
ech_rpiv=UPrandompivotal(pi_50)
HTestimator(y[ech_rpiv==1],pi_50[ech_rpiv==1])

#########################################################
#2.3 - Tirage de Poisson
#########################################################

#Probabilités d'inclusion proportionnelles à la taille
n=50
pi_50=inclusionprobabilities(averageincome,n)

#Tirage de Poisson et estimation du total de TaxableIncome
ech_poi=UPpoisson(pi_50)
y=TaxableIncome
est_ht=HTestimator(y[ech_poi==1],pi_50[ech_poi==1])
est_ht

#Estimation de variance de HT
pikl_poi_50=pi_50 %*% t(pi_50) +diag(pi_50-pi_50*pi_50)
varHT(y[ech_poi==1],pikl_poi_50[ech_poi==1,ech_poi==1],1)

#Estimation de variance (package GUSTAVE)  
y_mat <- matrix(y, ncol = 1)
var_pois(y_mat[ech_poi==1, , drop = FALSE],pi_50[ech_poi==1])

#########################################################
#2.4 - Tirage de Poisson conditionnel
#########################################################

#Probabilités d'inclusion proportionnelles à la taille
n=50
pi_50=inclusionprobabilities(averageincome,n)
options("scipen"=-100,digits="5")

#Tirage réjectif et estimation du total de TaxableIncome
ech_rej=UPmaxentropy(pi_50)
y=TaxableIncome
est_ht=HTestimator(y[ech_rej==1],pi_50[ech_rej==1])
est_ht

#Estimateur de variance de HT
pikl_rej_50=UPmaxentropypi2(pi_50)
varHT(y[ech_rej==1],pikl_rej_50[ech_rej==1,ech_rej==1],1)

#Estimateur de variance de YG
varHT(y[ech_rej==1],pikl_rej_50[ech_rej==1,ech_rej==1],2)

#Estimateur de variance de Deville (package SAMPLING)
varest(y[ech_rej==1],,pi_50[ech_rej==1],)

#Estimateur de variance de Deville (package GUSTAVE)
varDT(y[ech_rej==1],pi_50[ech_rej==1])

################################################################
#Une étude par simulations : variance des méthodes randomisées 
################################################################
n=100
pi=inclusionprobabilities(Tot04,n)

sim=10000
#Pile des simulations pour Men04, Women04, TaxableIncome
pile_sysrand=array(0,c(sim,3))
pile_pivrand=array(0,c(sim,3))
pile_samp=array(0,c(sim,3))

#Horvitz-Thompson estimator
ht_sysrand=numeric(3)
ht_pivrand=numeric(3)
#ht_samp=numeric(3)

for(i in 1:sim)
{
  cat("Simulation ",i,"\n")
  #Selection de l'échantillon systématique randomisé et estimation
  ech=UPrandomsystematic(pi)
  ht_sysrand[1]=HTestimator(Men04[ech==1],pi[ech==1])
  ht_sysrand[2]=HTestimator(Women04[ech==1],pi[ech==1])
  ht_sysrand[3]=HTestimator(TaxableIncome[ech==1],pi[ech==1])
  #Selection de l'échantillon du pivot randomisé et estimation
  ech=UPrandompivotal(pi)
  ht_pivrand[1]=HTestimator(Men04[ech==1],pi[ech==1])
  ht_pivrand[2]=HTestimator(Women04[ech==1],pi[ech==1])
  ht_pivrand[3]=HTestimator(TaxableIncome[ech==1],pi[ech==1])
  #Selection de l'échantillon de Rao-Sampford et estimation
  #ech=UPsampford(pi)
  #ht_samp[1]=HTestimator(Men04[ech==1],pi[ech==1])
  #ht_samp[2]=HTestimator(Women04[ech==1],pi[ech==1])
  #ht_samp[3]=HTestimator(TaxableIncome[ech==1],pi[ech==1])
  #Empilement
  pile_sysrand[i,]=ht_sysrand
  pile_pivrand[i,]=ht_pivrand
  #pile_samp[i,]=ht_samp
}

#Variance sous un plan réjectif
pikl=UPmaxentropypi2(pi)
var_Men04 <- t(Men04/pi) %*%(pikl-pi %*% t(pi)) %*%(Men04/pi)
var_Women04 <- t(Women04/pi) %*%(pikl-pi %*% t(pi)) %*%(Women04/pi)
var_TaxableIncome <- t(TaxableIncome/pi) %*%(pikl-pi %*% t(pi)) %*%(TaxableIncome/pi)
var=c(var_Men04,var_Women04,var_TaxableIncome)
#Variance de Monte Carlo des estimateurs
Vmc_sysrand=c(var(pile_sysrand[,1]),var(pile_sysrand[,2]),var(pile_sysrand[,3]))
Vmc_pivrand=c(var(pile_pivrand[,1]),var(pile_pivrand[,2]),var(pile_pivrand[,3]))
#Vmc_samp=c(var(pile_samp[,1]),var(pile_samp[,2]),var(pile_samp[,3]))
options("scipen"=-100,digits=4)
var
Vmc_sysrand
Vmc_pivrand

#########################################################
#3 - Echantillonnage équilibré
#########################################################

#########################################################
#3.2 - La méthode du Cube
#########################################################

#########################################################
#Exemple extrait de la documentation de "sampling"
#########################################################
data(MU284)
# Computation of the inclusion probabilities
pik=inclusionprobabilities(MU284$P75,50)
# Definition of the matrix of balancing variables
X=cbind(MU284$P75,MU284$CS82,
        MU284$SS82,MU284$S82,MU284$ME84)
# Computation of the Horvitz-Thompson estimator for a
# balanced sample
s=samplecube(X,pik,1,TRUE)

#########################################################
#3.3 - Estimation de variance
#########################################################

# Matrice des variables d'équilibrage
X=cbind(MU284$P75,MU284$CS82,MU284$SS82,MU284$S82)

# Sample selection and Horvitz-Thompson estimation
s=samplecube(X,pik,1,TRUE)
y <- MU284$RMT85
HTestimator(y[s==1],pik[s==1])

# Estimation de variance DT : package GUSTAVE
varDT(y[s==1],pik[s==1],X[s==1,])

#########################################################
#Application 
#########################################################
library(sas7bdat)
commune<-read.sas7bdat("commune.sas7bdat") 
attach(commune)

#Q1
n=...
Npop=...
pi1=rep(...,...)
ech=samplecube()


#Q2
HTestimator()
varDT()

(...)

#Q3

X=cbind(...,...)
ech=samplecube()

#Q4
HTestimator()
varDT()

(...)

#Q5
n=...
pi1=inclusionprobabilities()

un=rep(1,Npop)
X=cbind(NLOG,un,...)
ech=samplecube()

#Q6
HTestimator()
varDT()

(...)

##############################################################
#Application : découpage de commune en 4 groupes de rotation 
##############################################################

#Tirage du 1er groupe de rotation
n=250
Npop=1000
pi=rep(n/Npop,Npop)

FEM=f0019+f2039+f4059+f6074+f7599
HOM=h0019+h2039+h4059+h6074+h7599
X=cbind(pi,FEM,HOM,NLOG)
ech1=samplecube(X,pi,1,TRUE)
ident_ech1=ident[ech1==1]

#Tirage du second groupe de rotation
n=250
Npop=750
pi=rep(n/Npop,Npop)
ident_reste=ident[ech1==0]
Xreste=X[ech1==0,]
ech2=samplecube(Xreste,pi,1,TRUE)
ident_ech2=ident_reste[ech2==1]

#Tirage des groupes de rotation 3 et 4
n=250
Npop=500
pi=rep(n/Npop,Npop)
ident_reste=ident_reste[ech2==0]
Xreste=Xreste[ech2==0,]
ech3=samplecube(Xreste,pi,1,TRUE)
ident_ech3=ident_reste[ech3==1]
ident_ech4=ident_reste[ech3==0]